property exceptions : "Admin|Serv|Svr|Srvr|Xserv|Xsan"


property actionButton : missing value
property intelButton : missing value
property ppcButton : missing value
property optionsMatrix : missing value
property prefsPanel : missing value
property wgetPath : missing value


on clicked theObject
	if name of theObject is "intel" or name of theObject is "ppc" then
		set enabled of actionButton to ((state of ppcButton) + (state of intelButton))
		--
	else if name of theObject is "prefs" then
		doPrefsPanel()
		--
	else if name of theObject is "action" then
		set enabled of actionButton to false
		set title of actionButton to "Stop"
		tell progress indicator "spinner" of window "main" to start
		
		--URLs fr nicht bentigte CPU-Version weglassen
		set dontLoad to exceptions
		if state of ppcButton is 0 then set dontLoad to exceptions & "|PPC"
		if state of intelButton is 0 then set dontLoad to exceptions & "|Intel"
		
		getUpdates(current row of optionsMatrix, dontLoad)
		
		tell progress indicator "spinner" of window "main" to stop
		setStatus("")
		set title of actionButton to "Start"
		set enabled of actionButton to true
	end if
end clicked


on getUpdates(option, dontLoad)
	local tmp, wgetCmd, urls, allURLsFile, cpuURLs, urlList, urlListFile, basePath, basePathU, oneURL, pool
	
	setStatus("configParams")
	set sharedNetworkSettings to call method "sharedNetworkSettings" of class "NSNetworkSettings"
	if not (call method "connectedToInternet:" of sharedNetworkSettings with with parameter) as boolean then
		handleError("noInternetConnection")
		return
	end if
	
	--Proxy?
	set tmp to getProxyForServer("http://swscan.apple.com")
	if tmp contains "http" then
		set wgetCmd to wgetPath & "-e http_proxy=" & tmp & " --proxy=on "
	else
		set wgetCmd to wgetPath
	end if
	
	--temporren Dateinamen generieren
	set sucatalog to POSIX path of randomTempFilename("sumirror.sucatalog")
	
	--Update-Liste vom Apple-Server laden
	setStatus("getSUCatalog")
	try
		do shell script "/bin/mkdir -p ~/Library/Logs"
		set catalog to do shell script wgetCmd & "-N -O " & sucatalog & " http://swscan.apple.com/content/catalogs/index-1.sucatalog"
	on error what
		log what
		handleError("wgetError")
		return
	end try
	
	--alle URLs extrahieren und in allURLsFile abspeichern
	setStatus("extractURLs")
	set urls to do shell script "/usr/bin/awk -F'>' '/string/ {print $2}' " & sucatalog & " | /usr/bin/awk -F'<' '{print $1}'"
	set tmp to saveData2File("allURLs", urls as text)
	set allURLsFile to tmp & ".1"
	
	--Mac- in Unix-Zeilenenden umwandeln, sonst grep'ts nicht
	do shell script "/usr/bin/tr '\\r' '\\n' < " & tmp & " > " & allURLsFile
	
	--unntige URLs eliminieren
	setStatus("processURLs")
	set cpuURLs to do shell script "/usr/bin/grep -v -i -E '" & dontLoad & "' " & allURLsFile
	
	--urlListFile enthlt alle Pfade fr wget
	set tmp to saveData2File("cpuURLs", cpuURLs as text)
	set urlListFile to tmp & ".1"
	
	--Mac- in Unix-Zeilenenden umwandeln, sonst mag wget nicht
	do shell script "/usr/bin/tr '\\r' '\\n' < " & tmp & " > " & urlListFile
	
	--Speicherorte ermitteln
	if option is 1 then
		--Disk-Image anlegen unter imagePath
		--Pakete liegen am Ende unter ~/Documents/Offline-Update
		set basePath to (path to documents folder as string)
		--
	else if option is 2 then
		--externes Laufwerk volumeName
		--Pakete liegen am Ende unter /Volumes/volumeName/Offline-Update
		set tmp to (contents of default entry "volumeName" of user defaults)
		if tmp is not in (list disks) then
			handleError(localizedString("missingExternal_1") & tmp & localizedString("missingExternal_2"))
			return
		else
			set basePath to tmp & ":"
		end if
		--
	else if option is 3 then
		--Server-Pfad
		set basePath to (path to sites folder as string)
		--
	else
		handleError("quirkyOptions")
		return
	end if
	
	-- Verzeichnisse anlegen, falls ntig
	tell application "Finder"
		try
			get info for alias (basePath & "Offline-Update:") without size
		on error
			make new folder at alias basePath with properties {name:"Offline-Update"}
		end try
		
		try
			get info for alias (basePath & "Offline-Update:Pakete:") without size
		on error
			make new folder at alias (basePath & "Offline-Update:") with properties {name:"Pakete"}
		end try
	end tell
	
	set basePath to basePath & "Offline-Update:"
	set basePathU to escapeSpaces(POSIX path of basePath)
	
	--Update-Pakete herunterladen
	setStatus("loadPackages")
	try
		do shell script wgetCmd & "-N -i " & urlListFile & " -P " & basePathU & "Pakete"
	on error what
		handleError("wgetError")
		return
	end try
	
	--Dateien lschen, die in Pakete liegen, aber nicht in der Liste der bentigten stehen
	if (contents of default entry "removeOldPackages" of user defaults) is 1 then
		setStatus("optimizingPackages")
		set urlList to (do shell script "/bin/cat " & urlListFile)
		set pool to (list folder (basePath & "Pakete:"))
		
		repeat with oneURL in pool
			if oneURL is not in urlList then
				try
					setStatus(localizedString("removingFile_1") & oneURL & localizedString("removingFile_2"))
					do shell script ("/bin/rm " & (basePathU & "Pakete/" & oneURL))
					setStatus("optimizingPackages")
				end try
			end if
		end repeat
	end if
	
	setStatus("createSUCatalog")
	if option is 1 then
		do shell script "/usr/bin/sed -e 's|<string>http://swcdn.*/\\(.*\\)</string>|<string>file:///Volumes/Offline-Update/Pakete/\\1</string>|g' " & sucatalog & " > " & (basePathU & "update.sucatalog")
		
		try
			setStatus("createImage")
			do shell script "/usr/bin/hdiutil create -ov -srcfolder " & basePathU & " -volname Offline-Update " & (escapeSpaces(contents of default entry "imagePath" of user defaults) & "Offline-Update.dmg")
		on error
			handleError("hdiutilError")
			return
		end try
		--
	else if option is 2 then
		do shell script "/usr/bin/sed -e 's|<string>http://swcdn.*/\\(.*\\)</string>|<string>file:///Volumes/" & escapeSpaces(contents of default entry "volumeName" of user defaults) & "/Offline-Update/Pakete/\\1</string>|g' " & sucatalog & " > " & (basePathU & "update.sucatalog")
		--
	else if option is 3 then
		do shell script "/usr/bin/sed -e 's|<string>http://swcdn.*/\\(.*\\)</string>|<string>http://" & (contents of default entry "websitesPath" of user defaults) & "/Offline-Update/Pakete/\\1</string>|g' " & sucatalog & " > " & (basePathU & "update.sucatalog")
		--
	end if
end getUpdates


on setStatus(msg)
	set contents of text field "status" of window "main" to localizedString(msg)
	call method "displayIfNeeded" of window "main"
end setStatus


on awake from nib theObject
	local tmp
	
	set actionButton to (button "action" of window "main")
	set intelButton to (button "intel" of window "main")
	set ppcButton to (button "ppc" of window "main")
	set optionsMatrix to (matrix "options" of window "main")
	
	readOliUPrefs()
	
	set tmp to (contents of default entry "architecture" of user defaults)
	if "Intel" is in tmp then set state of intelButton to 1
	if "PPC" is in tmp then set state of ppcButton to 1
	
	set current row of optionsMatrix to (contents of default entry "action" of user defaults)
	
	set wgetPath to escapeSpaces((resource path of main bundle)) & "/wget -o " & POSIX path of (path to home folder as string) & "Library/Logs/wget_swupdate.log "
end awake from nib


on will quit theObject
	saveOliUPrefs()
end will quit


on readOliUPrefs()
	--Default-Einstellungen schreiben, fr den Fall, dass noch keine vorhanden sind
	--existieren bereits welche, werden diese NICHT berschrieben
	tell user defaults
		make new default entry at end of default entries with properties {name:"architecture", content:{"Intel", "PPC"}}
		make new default entry at end of default entries with properties {name:"action", content:1}
		make new default entry at end of default entries with properties {name:"imagePath", content:(POSIX path of (path to desktop folder))}
		make new default entry at end of default entries with properties {name:"volumeName", content:"iPod"}
		make new default entry at end of default entries with properties {name:"websitesPath", content:"192.168.1.100/~update"}
		make new default entry at end of default entries with properties {name:"removeOldPackages", content:0}
		make new default entry at end of default entries with properties {name:"useSystemProxy", content:1}
		make new default entry at end of default entries with properties {name:"proxyServer", content:""}
		make new default entry at end of default entries with properties {name:"proxyPort", content:0}
	end tell
	call method "synchronize" of object user defaults
end readOliUPrefs


on saveOliUPrefs()
	local tmp
	
	set tmp to {}
	if state of intelButton is 1 then set tmp to {"Intel"}
	if state of ppcButton is 1 then set tmp to tmp & "PPC"
	set contents of default entry "architecture" of user defaults to tmp
	
	set contents of default entry "action" of user defaults to (current row of optionsMatrix)
	
	call method "synchronize" of object user defaults
end saveOliUPrefs


on doPrefsPanel()
	local tmp
	
	if prefsPanel is equal to missing value then
		load nib "PrefsPanel"
		set prefsPanel to window "prefs"
	end if
	
	tell prefsPanel
		set tmp to my (contents of default entry "imagePath" of user defaults)
		set alternate title of button "imagePathBtn" to tmp
		set tmp to (call method "lastPathComponent" of tmp)
		set contents of text field "imagePath" to tmp
		
		set contents of text field "volumeName" to my (contents of default entry "volumeName" of user defaults)
		set contents of text field "websitesPath" to my (contents of default entry "websitesPath" of user defaults)
		
		set state of button "removeOldPackages" to my (contents of default entry "removeOldPackages" of user defaults)
		
		set tmp to my (contents of default entry "useSystemProxy" of user defaults)
		set current row of matrix "proxyOptions" to tmp
		set enabled of text field "proxyServer" to (tmp = 2)
		set enabled of text field "proxyPort" to (tmp = 2)
		set contents of text field "proxyServer" to my (contents of default entry "proxyServer" of user defaults)
		set contents of text field "proxyPort" to my (contents of default entry "proxyPort" of user defaults)
	end tell
	
	display panel prefsPanel attached to window "main"
end doPrefsPanel


on panel ended thePanel with result theResult
	if theResult is 1 then
		tell thePanel
			set contents of my default entry "imagePath" of user defaults to (alternate title of button "imagePathBtn")
			set contents of my default entry "volumeName" of user defaults to (contents of text field "volumeName")
			set contents of my default entry "websitesPath" of user defaults to (contents of text field "websitesPath")
			set contents of my default entry "removeOldPackages" of user defaults to (state of button "removeOldPackages")
			set contents of my default entry "useSystemProxy" of user defaults to (current row of matrix "proxyOptions")
			set contents of my default entry "proxyServer" of user defaults to (contents of text field "proxyServer")
			set contents of my default entry "proxyPort" of user defaults to (contents of text field "proxyPort")
		end tell
		call method "synchronize" of object user defaults
	end if
end panel ended


on choose menu item theObject
	if name of theObject is "prefsItem" then
		doPrefsPanel()
	else if name of theObject is "closeItem" then
		quit me
	end if
end choose menu item


on escapeSpaces(path)
	return do shell script "echo '" & path & "' | /usr/bin/sed -e 's|[ ]|\\\\ |g'"
end escapeSpaces


on saveData2File(fileName, theData)
	local thePath, theFile
	
	set thePath to randomTempFilename(fileName)
	set theFile to open for access thePath with write permission
	write theData to theFile
	close theFile
	
	return (POSIX path of thePath)
end saveData2File


on getProxyForServer(serverURL)
	if (contents of default entry "useSystemProxy" of user defaults) is 1 then
		set theURLWithString to call method "URLWithString:" of class "NSURL" with parameter serverURL
		set sharedNetworkSettings to call method "sharedNetworkSettings" of class "NSNetworkSettings"
		set proxyPropertiesForURL to call method "proxyPropertiesForURL:" of sharedNetworkSettings with parameter theURLWithString
		
		try
			tell |kCFStreamPropertyHTTPProxy| of proxyPropertiesForURL
				if ((its |HTTPEnable|) = 1) then
					return "http://" & its |HTTPProxy| & ":" & (its (|HTTPPort|) as integer)
				else
					return ""
				end if
			end tell
		on error what
			return ""
		end try
	else
		return "http://" & (contents of default entry "proxyServer" of user defaults) & ":" & ((contents of default entry "proxyPort" of user defaults) as integer)
	end if
end getProxyForServer


on randomTempFilename(seedName)
	local thePath
	
	repeat
		set thePath to (path to startup disk as string) & "private:tmp:" & seedName & "." & (random number 1000000) as string
		
		try
			set i to info for alias thePath
		on error
			--"info for" hat einen Fehler gemeldet, es existiert also keine Datei mit dem berprften Namen
			exit repeat
		end try
	end repeat
	
	return thePath
end randomTempFilename


on handleError(msg)
	display dialog localizedString(msg) buttons {"OK"} default button 1
end handleError


on localizedString(key)
	return (localized string of key from table "InfoPlist")
end localizedString